#!/usr/bin/env python
# encoding: utf-8

############################################################################
# Karlíkovy úlohy k analýze.
# --------------------------------------------------------
# Spuštěním python zadani.py si můžete funkce vyzkoušet.
############################################################################

import sys

def karlikuvP1(n):
    """Jelikož jedno volání funkce stojí 3 až 5 operací (přiřazení,
    podmínka, návrat hodnoty, režii for cyklu, násobení a volání
    funkce zanedbejme), což je není ani dvojnásobný rozdíl,
    můžete počítat asymptotickou časovou složitost jen vzhledem
    k počtu volání karlikuvP1.
    Příklad je obzvláště vypečený, proto nám stačí, když uvedete
    pouze třídu asymptotické časové složitosti, rozhodně nepočítejte
    počet operací, ale jen řádově, kolikrát se funkce zavolá.

    """
    vysledek = 0
    if n == 0: return 2
    if n == 1: return 4
    vysledek = karlikuvP1(n-1) * karlikuvP1(n-2)
    return vysledek

def karlikuvP2(n):
    """U této funkce se můžete rozhodnout, zda spočítáte a zdůvodníte
    asymptotickou časovou složitost, nebo přímo vyčíslíte složitost
    funkce vzhledem k počtu operací (přiřazení, podmínka, návrat hodnoty;
    režii for cyklu, násobení a volání funkce zanedbejme).

    """
    vysledek = 0
    prvni = 2
    druhy = 4
    if n == 0: return prvni
    if n == 1: return druhy
    for i in range(n-1):
        vysledek = prvni * druhy
        prvni = druhy
        druhy = vysledek
    return vysledek    

def karlikuvP3(n):
    """U této funkce se můžete rozhodnout, zda spočítáte a zdůvodníte
    asymptotickou časovou složitost, nebo přímo vyčíslíte složitost
    funkce vzhledem k počtu operací (přiřazení, podmínka, návrat hodnoty;
    režii for cyklu, násobení a volání funkce zanedbejme).

    """
    vysledek = 0
    prvni = 2
    druhy = 4
    if n == 0: return prvni
    if n == 1: return druhy
    for i in range(n-n):
        vysledek = prvni * druhy
        prvni = druhy
        druhy = vysledek
    return vysledek

def karlikuvP4(n):
    """Jelikož jedno volání funkce stojí 2 až 4 operací (přiřazení,
    podmínka, návrat hodnoty, režii for cyklu, násobení a volání
    funkce zanedbejme), což je max. dvojnásobný rozdíl,
    můžete počítat asymptotickou časovou složitost jen vzhledem
    k počtu volání karlikuvP4.

    """
    if n == 0: return 1
    if n == 1: return 1
    # operator // znaci celociselne deleni (v python 2 delí celociselne i /, zatimco v pythonu 3 uz ne)
    vysledek = n * karlikuvP4(n//2)
    #print vysledek
    return vysledek

def karlikuvP5(n):
    """U této funkce se můžete rozhodnout, zda spočítáte a zdůvodníte
    asymptotickou časovou složitost, nebo přímo vyčíslíte složitost
    funkce vzhledem k počtu operací (přiřazení, podmínka, návrat hodnoty;
    režii for cyklu, násobení a volání funkce zanedbejme).

    """
    mezivysledek = []
    vysledek = []
    prvni = 2
    druhy = 4
    if n == 0: return 2
    if n == 1: return 4
    for i in range(n-1):
        #funkce append zaradi prvek na konec pole, ma konstatni slozitost
        mezivysledek.append(prvni * druhy)
        prvni = druhy
        druhy = mezivysledek[i]
        #print mezivysledek[i]
    for i in range(n-1):
        if i % 2 == 0:
            vysledek.append(mezivysledek[i])
    return vysledek    
    

if __name__ == '__main__':
    """Funkce je možné si vyzkoušet voláním python zadani.py.
    """
    # pomocna struktura s funkcemi, funkce lze ukladat to struktur stejne
    # jako promenne
    funkce = {
        1:karlikuvP1,
        2:karlikuvP2,
        3:karlikuvP3,
        4:karlikuvP4,
        5:karlikuvP5,
        }
    # volba funkce
    print 'Kolikatou funkci chces vyzkouset (1 az 5)?'
    volba_funkce = input('Vyber funkci c.: ')
    if not volba_funkce in funkce:
        raise ValueError(
            'Zvolte takove cislo funkce, aby to bylo cislo 1 az 5.')
    # volba n
    print 'Kolikatou mocninu dvojky chces spocitat (n>=0)?'
    volba_n = input('Zvol n: ')
    if not (type(volba_n) == int and volba_n >= 0):
        raise ValueError(
            "Zadali jste neplatne n. Zkuste program spustit znovu.")
    # volání [volba_funkce]. funkce s parametrem [volba_n]
    vysledek = funkce[volba_funkce](volba_n)
    print "Vysledek je %s." % vysledek    


